// entities from backend
// https://github.yandex-team.ru/CRM/crm/blob/develop/space/Crm.Core/Entities.cs
import objToKeyObj from 'utils/objToKeyObj';

export enum EType {
  None = 0,
  Mail = 1,
  SpTicketComment = 2,
  Client = 3,
  TempContainer = 4,
  SpTicketCommentHist = 5,
  Template = 6,
  SpTicket = 7,
  SpCall = 8,
  OComment = 9,
  ReqRequest = 10,
  RequestMessage = 11,
  RequestNote = 12,
  TemplateQueue = 13,
  TemlateNotification = 14,
  TemplateShared = 15,
  MailTemplate = 16,
  MailSignature = 17,
  Account = 20,
  AccountComment = 21,
  User = 22,
  Massmail = 23,
  Contact = 24,
  RawCall = 25,
  YatelTenant = 26,
  YatelContact = 27,
  Tag = 28,
  MassmailRecipient = 29,
  ReviewCalc = 30,
  Category = 31,
  AccountSt = 32,
  SenderMail = 33,
  Issue = 34,
  AccountKik = 35,
  Timer = 36,
  ChatChunk = 37,
  UserGroup = 38,
  Notification = 39,
  Chat = 40,
  YcCall = 41,
  PersonalDashboard = 42,
  ContactCommMediumLinkTag = 43,
  Meeting = 44,
  CategoryAlert = 45,
  PlannedActivity = 46,
  ManagerActivity = 47,
  ChatMessage = 48,
  ExternalPassportUser = 52,
  InternalChatMessage = 55,

  BalanceClient = 101,
  BalancePerson = 102,
  DirectUser = 103,
  DirectUserRecommend = 104,
  DirectCampaign = 105,
  YatelTenantWorkPhone = 106,
  BalanceContract = 107,
  DirectVerified = 108,
  SpActivity = 109,
}

export const ETypeString = objToKeyObj(EType);

export interface EObject {
  eid: number;
  etype: keyof typeof EType;
}
