import { Tag } from 'types';
import { User } from '../user';
import { Categorization } from '../categorization';
import { UpsaleFactors } from '../upsale';

type Etype = 'YcCall';

export interface CallOptions {
  upsaleFactors?: UpsaleFactors;
  callId: string;
  callStatus: CallStatus;
  tags?: Tag[];
}

export interface CallStatus {
  id: 1 | 2;
  name: 'В процессе' | 'Завершён';
}

export interface Call {
  id: number;
  eType: Etype;
  author: User;
  dt: string;
  duration: number | null; // длительность в секундах
  clientInfo?: {
    phone?: string; //номер клиента
    name?: string; // ФИО клиента
  };
  direction: {
    id: 1 | 2 | 4;
    name: 'Входящий' | 'Исходящий' | 'Дайлерный';
  };
  kik?: {
    id: number;
    name: string;
    firstName: string;
    phone: string;
    phoneE164: string;
    email?: string;
    isBroadcast?: boolean;
    isMain?: boolean;
    modifiedOn?: string;
    source?: string;
    hidden?: boolean;
  };
  recordId: string; // идентификатор, по которому можно построить ссылку на запись разговора,
  callId: string; // идентификатор звонка в YaCalls
  operatorPhoneNumber: string; // номер телефона оператора
  endReason: {
    // причина завершения звонка
    id: number;
    name: string;
    success?: boolean;
  } | null;
  callStatus: CallStatus;
  categorization: Categorization;
  upsaleFactors?: UpsaleFactors;
  tags?: Tag[];
  issues?: unknown[];
}

export interface YcCallShortHistoryContainer {
  id: number;
  date: string;
  type: Etype;
  connection: string;
  call: {
    id: number;
    author: User;
    hasFactors: boolean;
    date: string;
    direction: 'In' | 'Out';
    categorization?: Categorization;
    comment?: string;
    tags?: Tag[];
  };
  parent: {
    id: number;
    type: 'Issue' | 'ManagerActivity';
    issue?: {
      id: number;
      type: string;
      typeId: number;
    };
  };
}
