export interface Dictionary {
  id: number;
  name: string;
}

export interface Language extends Dictionary {
  code: string;
}

export interface Author {
  id: number;
}

export interface CommentData {
  text: string;
  author: Author;
  date: string;
}

export interface Email {
  id: number;
  email: string;
  isBroadcast: boolean;
}

export interface PhoneData {
  id: number;
  phone: string;
  phoneExt?: string;
  phoneE164: string;
}

export interface ContactData {
  contactId: number;
  isMain?: boolean;
  comment?: CommentData;
  firstName: string;
  lastName?: string;
  middleName?: string;
  position?: Dictionary;
  emails?: Email[];
  phones?: PhoneData[];
  source?: string;
  language?: Language;
  modifiedOn?: string;
}

export interface ContactMassmailData {
  id: number;
  firstName: string;
  lastName?: string;
  middleName?: string;
  isBroadcast: boolean;
  position?: Dictionary;
  email: string;
}

export interface OId {
  eId: number;
  eType: string;
}

export interface WithOId {
  oId: OId;
}

export interface Account {
  id: number;
  contacts?: {
    items: ContactData[];
  };
  importedKiks?: {
    items: ContactData[];
  };
  info: {
    login: string;
    name?: string;
  };
}

export interface StarTrek {
  key: string;
  state: string;
  title: string;
}

export interface Tag {
  id: number;
  color: string;
  name: string;

  type?: string;
  isArchived?: boolean;
  isReadOnly?: boolean;
}

export interface IssueEntity {
  id: number;
  name: string;
}
