/* eslint-disable camelcase */

export interface XivaSubscriptionAuthTokens {
  ts: string;
  sign: string;
}

export interface XivaSubscriptionParams {
  uid: string;
  service: string;
  client: string;
  session: string;
  topic?: string;
}

export type XivaSubscriptionParamsAny =
  | XivaSubscriptionParams
  | (XivaSubscriptionParams & XivaSubscriptionAuthTokens);

export type XivaExistSubscriptionParamsAny = XivaSubscriptionParamsAny & {
  subscription_token: string;
};

export interface XivaMethod<Method extends string, Params> {
  method: Method;
  params: Params;
  id?: string;
}

export interface XivaMethodResponse<Result> {
  id?: string;
  error?: number;
  reason?: string;
  result?: Result;
}

export type XivaSubscribeMethod = XivaMethod<'/subscribe', XivaSubscriptionParamsAny>;

export type XivaSubscribeMethodResponse = XivaMethodResponse<{
  operation: 'attached';
  subscription_token: string;
}>;

export type XivaUnsubscribeMethod = XivaMethod<'/unsubscribe', XivaExistSubscriptionParamsAny>;

export type XivaUnsubscribeMethodResponse = XivaMethodResponse<{
  operation: 'detached';
}>;

export type XivaPingMethod = XivaMethod<'/ping', {}>;

export type XivaPingMethodResponse = XivaMethodResponse<'pong'>;

export interface XivaMessage<Data> {
  method: '/push';
  params: {
    data: Data;
    subscription_token: string;
  };
}

export type XivaNotificationMessage = XivaMessage<{
  bright: boolean;
  lcn: string;
  message: string;
  operation: string;
  position: number;
  server_notify_id: string;
  service: string;
  session_key: string;
  tags: string[];
  uid: string;
  version: string;
}>;

export type XivaDisconnectedMessage = XivaMessage<{
  event: 'disconnected';
  message: string;
  operation: 'disconnected';
  service: string;
  uid: string;
}>;

export type XivaErrorMessage = XivaMessage<{
  message: string;
  operation: 'xivaws-error';
}>;

export type XivaNotificationMessageAny =
  | XivaNotificationMessage
  | XivaDisconnectedMessage
  | XivaErrorMessage;

export type XivaMessageAny =
  | XivaSubscribeMethod
  | XivaUnsubscribeMethod
  | XivaPingMethod
  | XivaNotificationMessage
  | XivaDisconnectedMessage
  | XivaErrorMessage
  | XivaPingMethodResponse
  | XivaUnsubscribeMethodResponse
  | XivaSubscribeMethodResponse;

export type XivaMethodAny = XivaSubscribeMethod | XivaUnsubscribeMethod | XivaPingMethod;
