import { createElement } from 'react';
import cx from 'classnames';
import css from './BaseControl.modules.scss';

const baseControl = config => (WrappedComponent) => {
  const BaseControl = (props) => {
    const { className, ...passPropsThrough } = props;

    return createElement(
      WrappedComponent,
      { className: cx(className, css.BaseControl), ...passPropsThrough },
    );
  };

  BaseControl.defaultProps = {
    ...config,
  };

  return BaseControl;
};

export default baseControl;
