import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import defaultTheme from './styles.modules.scss';

const Menu = ({ theme, children, className, onClick, size }) => (
  <div className={cx(className, theme.root)} >
    {
      React.Children.map(children, (child) => {
        const { onClick: onChildClick, ...otherChildProps } = child.props;
        let newOnChildClick = onChildClick;
        if (onClick && onChildClick) {
          newOnChildClick = (e) => {
            onClick(e);
            onChildClick(e);
          };
        }

        const newComponent = React.cloneElement(child, {
          size,
          onClick: newOnChildClick,
          ...otherChildProps,
        });

        return newComponent;
      })
    }
  </div>
);

Menu.defaultProps = {
  theme: defaultTheme,
  className: undefined,
  children: undefined,
};

Menu.propTypes = {
  theme: PropTypes.objectOf(PropTypes.string),
  className: PropTypes.string,
  children: PropTypes.oneOfType([
    PropTypes.element,
    PropTypes.arrayOf(PropTypes.element),
  ]),
};

export default Menu;
