import React from 'react';
import css from './styles.modules.scss';
import cx from 'classnames';

const ModalField = (props) => {
  const { className, title, children, onClick, fieldRef, disabled, ...rest } = props;

  return (
    <a
      className={cx(css.root, className, { [css.isDisabled]: disabled })}
      tabIndex="0"
      onClick={!disabled ? onClick : undefined}
      title={title}
      ref={fieldRef}
      {...rest}
    >
      <span className={css.content}>{children || 'выбрать'}</span>
      <span className={cx('material-icons', css.pensil)}>mode_edit</span>
    </a>
  );
};

export default ModalField;
