import React from 'react';
import cx from 'classnames';
import css from './style.modules.scss';

const Root = ({ className, children }) => (
  <div className={cx(className, css.root)}>
    {children}
  </div>
);

const Left = ({ className, children }) => (
  <div className={cx(className, css.left)}>
    {children}
  </div>
);

const Right = ({ className, children }) => (
  <div className={cx(className, css.right)}>
    {children}
  </div>
);

const Toolbar = {
  Root,
  Left,
  Right,
};

export default Toolbar;
