import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import 'components/TreeView_old/style.css';
import 'components/TreeView_old/react-treeview.css';

const TreeNode = (props) => {
  const {
    nodeLabel,
    theme,
    className,
    itemClassName,
    children,
    selected,
    collapsed,
    onClick,
    onArrowClick,
    clickMode,
    type,
    labelClassName,
    offset,
    ...rest
  } = props;

  let wrapProps;
  let labelProps;

  let arrowClassName = theme.arrow || 'tree-view_arrow';
  let containerClassName = theme.children || 'tree-view_children';
  if (collapsed) {
    arrowClassName += theme.arrowCollapsed || ' tree-view_arrow-collapsed';
    containerClassName += theme.childrenCollapsed || ' tree-view_children-collapsed';
  }

  const labelType = type || type === 0 ? `tree-view_label-type-${type}` : null;

  if (clickMode === 'label') {
    labelProps = {
      onClick,
      className: cx(
        theme.labelWrap || 'tree-view_label-wrap',
        labelType,
        { [theme.selected]: selected },
        labelClassName,
      ),
    };
    wrapProps = {
      className: cx(itemClassName, theme.label || 'tree-view_label'),
    };
  } else {
    labelProps = {
      className: cx(theme.labelWrap || 'tree-view_label-wrap', labelType),
    };
    wrapProps = {
      onClick,
      className: cx(
        itemClassName,
        theme.label || 'tree-view_label',
        { [theme.selected]: selected },
        labelClassName,
      ),
    };
  }

  const arrow = (
    <div {...rest} className={`${className} ${arrowClassName}`} onClick={onArrowClick} />
  );

  if (children) {
    return (
      <div className={theme.nodeFolder}>
        <div {...wrapProps} style={{ paddingLeft: offset }}>
          {arrow}
          <div {...labelProps}>{nodeLabel}</div>
        </div>
        <div className={containerClassName}>{collapsed ? null : children}</div>
      </div>
    );
  }
  return (
    <div className={theme.nodeFile}>
      <div {...wrapProps} style={{ paddingLeft: offset }}>
        <div {...labelProps} title={nodeLabel.props.name}>
          {nodeLabel}
        </div>
      </div>
    </div>
  );
};

TreeNode.defaultProps = {
  theme: {},
  className: '',
  itemClassName: '',
};

TreeNode.propTypes = {
  nodeLabel: PropTypes.node.isRequired,
  // eslint-disable-next-line react/forbid-prop-types
  theme: PropTypes.object,
  offset: PropTypes.number,
  collapsed: PropTypes.bool,
  className: PropTypes.string,
  itemClassName: PropTypes.string,
  onClick: PropTypes.func,
  onArrowClick: PropTypes.func,
  clickMode: PropTypes.string,
};

export default TreeNode;
