import React from 'react';
import PropTypes from 'prop-types';
import TreeNode from './TreeNode';

class TreeNodeControlled extends React.Component {
  constructor(props) {
    super(props);

    this.state = { collapsed: this.props.defaultCollapsed };
  }

  handleClick = e => {
    if (this.props.onClick) {
      e.stopPropagation();
    }

    this.setState({ collapsed: !this.state.collapsed });

    if (this.props.onArrowClick) {
      this.props.onArrowClick(e);
    }
  };

  render() {
    const props = { ...this.props, onArrowClick: this.handleClick };
    if (props.collapsed == null) {
      props.collapsed = this.state.collapsed;
    }
    delete props.defaultCollapsed;

    return <TreeNode {...props} />;
  }
}

TreeNodeControlled.propTypes = {
  onClick: PropTypes.func,
  onArrowClick: PropTypes.func,
  collapsed: PropTypes.bool,
  defaultCollapsed: PropTypes.bool,
};

TreeNodeControlled.defaultProps = {
  onArrowClick: undefined,
  onClick: undefined,
  collapsed: undefined,
  defaultCollapsed: undefined,
};

export default TreeNodeControlled;
