/* eslint-disable no-bitwise */

export default class Access {
  public static MASKS = {
    read: 0b01,
    edit: 0b10,
  };

  public static TYPES = {
    restricted: 0b00,
    readonly: 0b01,
    fullaccess: 0b11,
  };

  /**
   * @param {Number} mask
   * @param {Number|Boolean} permissionCode - code number or flag
   * @return {Boolean}
   */
  public static normalizeToBoolean = (mask, permissionCode) => {
    if (Number.isInteger(permissionCode)) {
      return (permissionCode & mask) !== 0;
    }

    if (typeof permissionCode === 'boolean') {
      return permissionCode;
    }

    return false;
  };

  /**
   * @param {Number} permissionCodes - code number or flag
   * @return {Boolean}
   */
  public static and = (...permissionCodes) => {
    let resultPermissionCode;
    if (permissionCodes.length > 1) {
      resultPermissionCode = permissionCodes.reduce((pv, nv) => pv & nv);
    } else {
      [resultPermissionCode] = permissionCodes;
    }

    return resultPermissionCode;
  };

  public static create = flags =>
    Object.keys(flags).reduce((pv, nv) => pv | (flags[nv] ? Access.MASKS[nv] : 0), 0);

  /**
   * @param {Number|Boolean} permissionCode - code number or flag
   * @return {Boolean} - allow read
   */
  public static isRead = permissionCode =>
    Access.normalizeToBoolean(Access.MASKS.read, permissionCode);

  /**
   * @param {Number|Boolean} permissionCode - code number or flag
   * @return {Boolean} - allow edit
   */
  public static isEdit = permissionCode =>
    Access.normalizeToBoolean(Access.MASKS.edit, permissionCode);
}
