// eslint-disable-next-line @typescript-eslint/no-explicit-any
export type AdapterPropsType = (props: any) => any;

export default class Adapter<T> {
  private adapters: { [key: string]: T } = {};

  private _defaultAdapter: T;

  public constructor(defaultAdapter: T) {
    this._defaultAdapter = defaultAdapter;
  }

  public get defaultAdapter(): T {
    return this._defaultAdapter;
  }

  public copy(): Adapter<T> {
    const instance = new Adapter(this._defaultAdapter);
    const keys = Object.keys(this.adapters);
    keys.forEach((key) => {
      instance.add(key, this.adapters[key]);
    });
    return instance;
  }

  public add = (key: string, adapter: T): void => {
    this.adapters[key] = adapter;
  };

  public get = (key: string) => {
    return this.adapters[key];
  };

  public getOrDefault = (key: string) => {
    return this.adapters[key] || this._defaultAdapter;
  };
}
