import { EObject, ETypeString } from 'types/entities';
import { EType } from 'types/EType';

export interface EObjectFormatterOptions {
  delemitter?: string;
}

export class EObjectFormatter {
  private readonly options: Required<EObjectFormatterOptions>;

  constructor(options?: EObjectFormatterOptions) {
    this.options = { delemitter: ':', ...options };
  }

  parse(str: string): EObject {
    const delemitter = this.options.delemitter;

    let [maybeEtype, maybeEid] = str.split(delemitter);

    const eid = Number.parseInt(maybeEid, 10);
    if (Number.isNaN(eid)) {
      throw new Error(`eid is not number: ${eid}}`);
    }

    if (!ETypeString[maybeEtype]) {
      throw new Error(`etype is not supported: ${maybeEtype}`);
    }

    return { eid, etype: maybeEtype as EType };
  }

  parseSafe(str: string): EObject | undefined {
    try {
      return this.parse(str);
    } catch (e) {
      return undefined;
    }
  }

  format(eObject: EObject) {
    return `${eObject.etype}${this.options.delemitter}${eObject.eid}`;
  }
}
