import React from 'react';
import PropTypes from 'prop-types';
import Promise from 'bluebird';
import Spinner from 'components/Spinner';

/** @deprecated use components/lazyWithSuspense */
class LazilyLoad extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      modules: null,
      isLoaded: false,
    };
  }

  componentDidMount() {
    this.load(this.props);
  }

  componentWillReceiveProps(nextProps) {
    const shouldLoad = Boolean(
      Object.keys(this.props.modules).filter(
        (key) => this.props.modules[key] !== nextProps.modules[key],
      ).length,
    );

    if (shouldLoad) {
      this.load(nextProps);
    }
  }

  load(props) {
    const { modules } = props;
    const keys = Object.keys(modules);
    Promise.all(keys.map((key) => modules[key]()))
      .then((values) =>
        keys.reduce((agg, key, index) => {
          agg[key] = values[index]; // eslint-disable-line no-param-reassign
          return agg;
        }, {}),
      )
      .then((result) => {
        if (this) {
          this.setState({ modules: result, isLoaded: true });
        }

        return null;
      });
  }

  render() {
    if (!this.state.isLoaded) {
      if (this.props.spinner) {
        return <Spinner modal={false} visible full />;
      }

      return null;
    }
    return this.props.children(this.state.modules);
  }
}

LazilyLoad.propTypes = {
  modules: PropTypes.instanceOf(Object).isRequired,
  children: PropTypes.func.isRequired,
  spinner: PropTypes.bool,
};

LazilyLoad.defaultProps = {
  spinner: false,
};

/** @deprecated use components/lazyWithSuspense */
export const importLazy = (promise) => promise.then((result) => result);

export default LazilyLoad;
