import { LinkedListNode } from './LinkedListNode';

export interface LinkedList<T> {
  readonly count: number;
  readonly first?: LinkedListNode<T>;
  readonly last?: LinkedListNode<T>;

  addLast(newNode: LinkedListNode<T>);
  addLast(value: T);

  addFirst(newNodeOrValue: LinkedListNode<T> | T);

  addAfter(currentNode: LinkedListNode<T>, newNodeOrValue: LinkedListNode<T> | T);

  removeNode(node: LinkedListNode<T>);

  clear();

  toArray(): T[];
  asArray: T[];
}
