import { LinkedList } from './LinkedList';

interface NodeLinks<T> {
  list?: LinkedList<T>;
  next?: LinkedListNode<T>;
  previous?: LinkedListNode<T>;
}

interface NodeValue<T> {
  value: T;
}

export interface LinkedListNode<T> extends Readonly<NodeLinks<T>>, NodeValue<T> {}

export interface MutableLinkedListNode<T> extends NodeLinks<T>, NodeValue<T> {}
