import Promise from 'bluebird';

export default abstract class Loadable {
  // eslint-disable-next-line
  public promise: Promise<any> | null = null;

  public load() {
    this.loadCancel();
    this.promise = this.loadRequest();
    return this.promise;
  }

  // eslint-disable-next-line
  abstract loadRequest(): Promise<any>;

  public loadCancel() {
    if (this.promise) {
      this.promise.cancel();
      this.promise = null;
    }
  }
}
