export class Timeout {
  private timeout: number;

  private callback: Function;

  private timeoutId: number | null;

  public constructor(callback: Function, timeout: number) {
    this.callback = callback;
    this.timeout = timeout;
  }

  public set() {
    this.timeoutId = window.setTimeout(this.callback, this.timeout);
  }

  public clear() {
    if (this.timeoutId != null) {
      window.clearTimeout(this.timeoutId);
    }
  }

  public reset() {
    this.clear();
    this.set();
  }
}
