export class UniqIdGenerator {
  static global: UniqIdGenerator;

  private static lastInstanceId = 0;

  private lastId = 0;
  private readonly instanceId: number;

  constructor(private readonly prefix: string = '') {
    this.instanceId = ++UniqIdGenerator.lastInstanceId;
  }

  next() {
    return `${this.prefix}:${this.instanceId}_${++this.lastId}`;
  }
}

UniqIdGenerator.global = new UniqIdGenerator();
