const MIN_HEIGHT = 600;
const MIN_WIDTH = 800;

const RATIO_HEIGHT = 0.7;
const RATIO_WIDTH = 0.7;

const TYPES = {
  MODAL: 'MODAL',
  TAB: 'TAB',
};

export default {
  TYPES,
  getPopupSize() {
    let width = RATIO_WIDTH * global.screen.width;
    let height = RATIO_HEIGHT * global.screen.height;

    width = width > MIN_WIDTH ? width : MIN_HEIGHT;
    height = height > MIN_HEIGHT ? height : MIN_WIDTH;

    return {
      width,
      height,
    };
  },
  open(url, type = TYPES.TAB) {
    if (!(url && (typeof url === 'string'))) {
      return null;
    }

    const fullUrl = `${global.location.origin}${global.location.pathname}#${url}`;
    const args = [];
    args.push(fullUrl);

    if (type === TYPES.MODAL) {
      args.push('_blank');
      const popupSize = this.getPopupSize();
      args.push(`toolbar=0,location=0,menubar=0,width=${popupSize.width},height=${popupSize.height}`);
    }

    return global.open(...args);
  },
};
