import { concatUrlAndSearchParams } from 'utils/concatUrlAndSearchParams';

export const buildUrl = (url: string, search = {}) => {
  const params = {};
  for (const key in search) {
    const val = search[key];
    if (val !== undefined) params[key] = String(val);
  }

  return concatUrlAndSearchParams(url, params) as string;
};
