import Promise from 'bluebird';

export default <T = unknown>(func: () => Promise<T>): (() => Promise<T>) => {
  let cache: T | undefined;
  let time = 0;
  const expiry = 5 * 60 * 1000;

  return () => {
    if (cache && time) {
      if (time + expiry > Date.now()) {
        return Promise.resolve(cache);
      }
      time = 0;
      cache = undefined;
    }

    return func().then(data => {
      cache = data;
      time = Date.now();

      return data;
    });
  };
};
