export default (html) => {
  if (!(typeof html === 'string' && html)) {
    return html;
  }

  const wrap = document.createElement('div');
  wrap.innerHTML = html;

  wrap.querySelectorAll('*').forEach((element) => {
    Object.values(element.attributes).forEach((attr) => {
      if (attr.name.startsWith('data-crm')) {
        element.removeAttribute(attr.name);
      }
    });
  });

  wrap.querySelectorAll('.crm-editor-factor').forEach((element) => {
    element.classList.remove('crm-editor-factor');
  });

  wrap.querySelectorAll('.spSignature').forEach((element) => {
    element.classList.remove('spSignature');
  });

  return wrap.innerHTML;
};
