export const concatUrlAndSearchParams = (
  url?: string,
  params?: Record<string, string> | undefined,
): string | undefined => {
  if (params && url) {
    const pathAndSearchParams = url.split('?');
    const path = pathAndSearchParams[0];
    const searchParams = new URLSearchParams(pathAndSearchParams[1]);
    for (let [key, value] of Object.entries(params)) {
      searchParams.append(key, value);
    }
    return `${path}?${searchParams.toString()}`;
  }
  return url;
};
