import * as React from 'react';

export default <C, Injected>({
  Context,
  propName = 'context',
}: {
  Context: React.Context<C>;
  propName: string;
}) => <P extends {}>(WrappedComponent: React.ComponentType<P & Injected>) => {
  class WithContext extends React.Component<P> {
    private renderWrappedComponent = (value: C) => {
      const context = ({ [propName]: value } as unknown) as Injected;

      return <WrappedComponent {...this.props as P} {...context} />;
    };

    public render() {
      return <Context.Consumer>{this.renderWrappedComponent}</Context.Consumer>;
    }
  }

  return WithContext;
};
