const exRegExp = /^ex:/i;

interface Params {
  local: string;
  external: string;
}

export default (config: Params) => (key: string): string => {
  let link: string;
  if (exRegExp.test(key)) {
    link = `${config.external}${key.replace(exRegExp, '')}`;
  } else {
    link = `${config.local}${key}`;
  }

  return link;
};
