import { Observable } from 'rxjs';
import { reaction, IReactionPublic, IReactionOptions } from 'mobx';

export type IReactionRxJSOptions = Omit<IReactionOptions, 'onError'> & { isThrowError?: boolean };

export function createObservableFromMobxReaction<T>(
  expression: (r: IReactionPublic) => T,
  opts?: IReactionRxJSOptions,
) {
  return new Observable<T>((subscriber) => {
    const { isThrowError, ...mobxReactionOptions } = opts || {};
    if (isThrowError) {
      (mobxReactionOptions as IReactionOptions).onError = subscriber.error.bind(subscriber);
    }

    return reaction(
      expression,
      (value) => {
        subscriber.next(value);
      },
      mobxReactionOptions,
    );
  });
}
