import connectionCheckerWorker from 'workers/connectionChecker.sharedworker';

const workerTypes = {
  connectionChecker: connectionCheckerWorker,
};

type WorkerTypes = typeof workerTypes;

export const createSharedWorker = (
  workerType: keyof WorkerTypes,
  globalName: string,
): SharedWorker => {
  const source = `importScripts("${workerTypes?.[workerType]?.()}");`;
  const workerUrl = 'data:application/javascript;base64,' + btoa(source);
  return new SharedWorker(workerUrl, { name: globalName });
};
