/**
 * HOC - позволяет "плавно" обновлять компоненты
 * например превью письма при выборе разных писем в списке писем
 **/
import React from 'react';
import PropTypes from 'prop-types';
import hoistNonReactStatic from 'hoist-non-react-statics';
import getDisplayName from 'utils/getDisplayName';
import Spinner from 'components/Spinner';

const dataChanger = () => (WrappedComponent) => {
  class DataChanger extends React.Component {
    componentWillReceiveProps(nextProps) {
      if (!nextProps.isLoad && this.props.isLoad) {
        this.saveProps = this.props;
      }

      if (this.saveProps && nextProps.isLoad && !nextProps.isFetch) {
        this.saveProps = null;
      }
    }

    render() {
      const renderProps = this.saveProps || this.props;
      return (
        <Spinner overlay visible={this.props.isFetch} inject>
          <WrappedComponent {...renderProps} />
        </Spinner>
      );
    }
  }

  /**
   * @type {object}
   * @prop {boolean} isLoad - получены данные с бекенда
   * @prop {boolean} isFetch - идет выполнение запроса
   */

  DataChanger.propTypes = {
    isLoad: PropTypes.bool,
    isFetch: PropTypes.bool,
  };
  DataChanger.defaultProps = {
    isLoad: undefined,
    isFetch: undefined,
  };
  DataChanger.displayName = `dataChanger(${getDisplayName(WrappedComponent)})`;

  return hoistNonReactStatic(DataChanger, WrappedComponent);
};

export default dataChanger;
