function pad(number) {
  if (number < 10) {
    return `0${number}`;
  }
  return number;
}

const toLocalISOString = (date) => {
  const timezoneOffsetMin = date.getTimezoneOffset();
  let offsetHrs = Math.abs(timezoneOffsetMin / 60);
  let offsetMin = Math.abs(timezoneOffsetMin % 60);
  let timezoneStandard;

  offsetHrs = pad(offsetHrs);
  offsetMin = pad(offsetMin);

  // getTimezoneOffset returns an offset which is positive
  // if the local timezone is behind UTC and vice-versa.
  // So add an opposite sign to the offset
  // If offset is 0, it means timezone is UTC
  if (timezoneOffsetMin < 0) {
    timezoneStandard = `+${offsetHrs}:${offsetMin}`;
  } else if (timezoneOffsetMin > 0) {
    timezoneStandard = `-${offsetHrs}:${offsetMin}`;
  } else if (timezoneOffsetMin === 0) {
    timezoneStandard = 'Z';
  }

  return date.getFullYear() +
    '-' + pad(date.getMonth() + 1) +
    '-' + pad(date.getDate()) +
    'T' + pad(date.getHours()) +
    ':' + pad(date.getMinutes()) +
    ':' + pad(date.getSeconds()) +
    '.' + (date.getMilliseconds() / 1000).toFixed(3).slice(2, 5) +
    timezoneStandard;
};

export default toLocalISOString;
