import debounce from 'lodash/debounce';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export const debounceWhenArgsChange = <T extends (...args: any) => void>(
  func: T,
  delay?: number,
) => {
  const debounced = debounce(func, delay);
  let prevArgs;

  const wrap = (...args) => {
    if (!prevArgs || args.some((arg, id) => prevArgs[id] !== arg)) {
      debounced(...args);
    }

    prevArgs = args;
  };

  return wrap as T;
};
