import { ExtendedOptions } from './fetchExtended.types';

const sleep = (time) => new Promise((res) => setTimeout(res, time));

export const fetchWithTimeout = async (resource, options: ExtendedOptions = {}) => {
  const { timeout = 5000 } = options;

  const abortController = new AbortController();
  const id = setTimeout(() => {
    abortController.abort();
  }, timeout);
  const response = await fetch(resource, {
    ...options,
    signal: abortController.signal,
  });
  clearTimeout(id);
  return response;
};

export const fetchExtended = async (url, options: ExtendedOptions = {}) => {
  const retry = options?.retryOptions?.count ?? 0;
  const fetchFunction = options?.timeout ? fetchWithTimeout : fetch;
  const retryLoop = async (retry) => {
    try {
      return await fetchFunction(url, options);
    } catch (error) {
      if (retry === 0) {
        throw error;
      }
      if (options?.retryOptions?.delay) {
        await sleep(options?.retryOptions?.delay);
      }
      return await retryLoop(retry - 1);
    }
  };
  if (retry > 0) {
    return await retryLoop(retry);
  }
  return await fetchFunction(url, options);
};
