const _filterTree = (data, text, isShowAll = false) => {
  if (data.type === 0 || data.items) {
    let _data = data;
    const index = data.name.toLowerCase().indexOf(text);
    const isMatch = index !== -1;
    if (isMatch) {
      _data = { ...data, select: [index, index + text.length] };
    }

    let newItemsArr;
    if (data.items) {
      data.items.forEach(item => {
        const res = _filterTree(item, text, isShowAll || !!isMatch);
        if (res) {
          newItemsArr = newItemsArr || [];
          newItemsArr.push(res);
        }
      });
    }

    if (isShowAll || isMatch || (newItemsArr && newItemsArr.length > 0)) {
      return { ..._data, items: newItemsArr };
    }

    return null;
  }

  if (data.type === 1 || !data.items) {
    const index = data.name.toLowerCase().indexOf(text);
    if (index !== -1) {
      return { ...data, select: [index, index + text.length] };
    }

    if (isShowAll) {
      return data;
    }
    return null;
  }

  return data;
};

const filterTree = (data, _text) => {
  if (!_text || _text === '') {
    return data;
  }

  if (data) {
    const text = _text.toLowerCase();

    if (Array.isArray(data)) {
      const res = [];
      for (let i = 0, l = data.length; i < l; i += 1) {
        const filted = _filterTree(data[i], text);
        if (filted) {
          res.push(filted);
        }
      }
      return res;
    }

    return _filterTree(data, text);
  }

  return data;
};

export default filterTree;

const filterNode = (map, id, text, res, isShowAll = false, options) => {
  const node = map[id];

  let isMatch = false;

  const { slugFilter, predicate } = options;

  if (typeof predicate === 'function') {
    const resultNode = predicate(node, text);
    if (resultNode) {
      res[id] = resultNode;
      isMatch = !!resultNode;
    }
  } else if (node[slugFilter]) {
    const index = node[slugFilter].toLowerCase().indexOf(text);
    isMatch = index !== -1;
    if (isMatch) {
      res[id] = { ...node, searchRange: [index, index + text.length] };
    }
  }

  if (!isMatch && isShowAll) {
    res[id] = node;
  }

  let isChildFound = false;
  if (node.items) {
    node.items.forEach(itemId => {
      const childResult = filterNode(map, itemId, text, res, isMatch || isShowAll, options);

      isChildFound = isChildFound || childResult;
    });
  }

  if (isChildFound) {
    res[id] = { ...res[id], ...node };
  }

  return isMatch || isChildFound;
};

/**
 * filterMap - filter normalize map of tree structor
 * @param map {object} : normalize map
 * @param rootId {number|string} : root id in map (map[rootId])
 * @param text {string} : substring for search
 * @param slugFilter {string} : slugFilter - field name for filter
 *
 * @return {object} : filter map
 * */
export const filterMap = (map, text, $options) => {
  const defaultOptions = {
    rootId: 'root',
    slugFilter: 'name',
  };

  const options = Object.assign({}, $options, defaultOptions);

  if (!text || text === '') {
    return map;
  }

  if (map) {
    const rootNode = map[options.rootId];
    if (rootNode) {
      const res = {};
      filterNode(map, options.rootId, text.toLowerCase(), res, false, options);
      return res;
    }
    return null;
  }
  return map;
};
