const filterNode = args => {
  const { node, predicate, childrenSlug, isShowAll } = Object.assign(
    { isShowAll: false, childrenSlug: 'content' },
    args,
  );
  const children = node[childrenSlug];
  if (children) {
    let nodeCopy = node;
    const pResult = predicate(node);
    if (pResult && typeof pResult !== 'boolean') {
      nodeCopy = pResult;
    }

    let childrenCopy;
    if (Array.isArray(children)) {
      children.forEach(child => {
        const res = filterNode({ ...args, node: child, isShowAll: isShowAll || !!pResult });
        if (res) {
          childrenCopy = childrenCopy || [];
          childrenCopy.push(res);
        }
      });
    }

    if (isShowAll || pResult || (childrenCopy && childrenCopy.length)) {
      return { ...nodeCopy, [childrenSlug]: childrenCopy };
    }

    return null;
  }
  const pResult = predicate(node);
  if (pResult) {
    if (typeof pResult !== 'boolean') {
      return pResult;
    }
    return node;
  }

  if (isShowAll) {
    return node;
  }

  return null;
};

export default filterNode;
