/* https://johann.pardanaud.com/blog/how-to-assert-unhandled-rejection-and-uncaught-exception-with-jest/ */

export const fixGlobalHandleErrorEventsForTests = () => {
  // Store the original listeners in an object containing
  // an array for each event we need to alter
  const originalJestListeners = {
    uncaughtException: [],
    unhandledRejection: [],
  };

  // For each event, we retrieve the registered listeners, store them
  // in our global object and remove them from the event emitter.
  beforeEach(() => {
    const originalProcess = process._original();
    Object.keys(originalJestListeners).forEach((event) => {
      originalProcess.listeners(event as never).forEach((listener) => {
        originalJestListeners[event].push(listener);
        originalProcess.off(event, listener);
      });
    });
  });

  // For each event, we retrieve the listeners stored in the global object
  // and we register them on the event emitter.
  afterEach(() => {
    let listener;
    Object.keys(originalJestListeners).forEach((event) => {
      while ((listener = originalJestListeners[event].pop()) !== undefined) {
        process._original().on(event as never, listener);
      }
    });
  });
};
