import { EventTarget } from 'event-target-shim';
import { Observable } from 'rxjs';

export const fromEventTargetShimEvent = <T extends EventTarget.EventDefinition, K extends keyof T>(
  target: EventTarget<T, {}>,
  event: K,
) =>
  new Observable<T[K]>((subscriber) => {
    const handle = (event) => {
      subscriber.next(event);
    };

    target.addEventListener(event, handle);

    return () => {
      target.removeEventListener(event, handle);
    };
  });
