import { UserOrLoginData } from '../components/Avatar/Avatar';
import { isExternalUser } from './isExternalUser';

export const getSign = ({ user, login = ' ' }: UserOrLoginData) => {
  if (user) {
    const { name, login } = user;
    let firstName;
    let lastName;

    if (!isExternalUser(user)) {
      ({ first_name: firstName, last_name: lastName } = user);
    }

    if (firstName && lastName) {
      return lastName[0] + firstName[0];
    }

    if (name) {
      return name
        .split(' ')
        .map((item) => item[0])
        .join('');
    }

    if (firstName || lastName) {
      return [lastName, firstName]
        .filter((item) => item)
        .map((item: string) => item[0])
        .join('');
    }

    if (login) {
      return login[0];
    }
  }

  return login[0];
};
