import isEvent from 'utils/isEvent';

const getValue = (event: Event) => {
  if (isEvent(event)) {
    const detypedEvent: any = event;
    const {
      target: { type, value, checked, files },
      dataTransfer,
    } = detypedEvent;
    if (type === 'checkbox') {
      return !!checked;
    }
    if (type === 'file') {
      return files || (dataTransfer && dataTransfer.files);
    }
    return value;
  }
  return event;
};

export default getValue;
