import React from 'react';
import ReactDOM from 'react-dom';
import { WikiFormatterHtml } from '@yandex-int/tools-components/WikiFormatter';
import { getSettings } from 'components/WikiFormatter';

let wikiFormatter: Ya.FormatterViewPort | null = null;
export const getWikiFormatter = (): Promise<Ya.FormatterViewPort> => {
  return new Promise((resolve) => {
    if (wikiFormatter) {
      resolve(wikiFormatter);
    }
    const wikiFormatterElement = document.getElementById('wiki-formatter');
    if (!wikiFormatterElement) {
      const wikiSettings = getSettings();

      const div = document.createElement('div');
      div.style.visibility = 'hidden';
      div.id = 'wiki-formatter';
      document.body.append(div);
      ReactDOM.render(
        <WikiFormatterHtml
          nonce={wikiSettings.nonce}
          settings={wikiSettings.settings}
          html=""
          onFormatterInstance={(instance) => {
            wikiFormatter = instance;
            resolve(wikiFormatter);
          }}
        />,
        div,
      );
    }
  });
};
