export default (onClick, onDblClick, delay = 250) => {
  let timeoutID = null;
  return (...args) => {
    if (!timeoutID) {
      timeoutID = setTimeout(() => {
        onClick(...args);
        timeoutID = null;
      }, delay);
    } else {
      timeoutID = clearTimeout(timeoutID);
      onDblClick(...args);
    }
  };
};
