import { config } from 'services/Config';
import { FlagDependantConfig } from '../useBunker.types';

export const mergeConfigs = <T extends FlagDependantConfig>(data: Array<T>) => {
  return data.reduce((acc, item) => {
    const { whenFlag } = item;

    return !whenFlag || config.value.features[whenFlag] ? { ...acc, ...item } : acc;
  }, {} as T);
};
