import { useCallback, useState } from 'react';

interface UseControlledProps<TValue> {
  defaultValue: TValue;
  value?: TValue;
}

export const useControlled = <TValue = unknown>({
  value,
  defaultValue,
}: UseControlledProps<TValue>): [TValue, (newValue: TValue) => void] => {
  const [valueState, setValueState] = useState<TValue>(defaultValue);

  const setValue = useCallback(
    (newValue: TValue) => {
      if (value === undefined) {
        setValueState(newValue);
      }
    },
    [value],
  );

  if (value !== undefined) {
    return [value, setValue];
  }

  return [valueState, setValue];
};
