import { useState, useMemo, useCallback } from 'react';

export const useDividableList = <T extends unknown>(
  list: T[],
  options?: {
    leftLength?: number;
  },
) => {
  const { leftLength = 3 } = options || {};

  const [isListDivided, setListDivided] = useState(true);

  const left = useMemo(() => {
    if (!isListDivided) {
      return list;
    }
    return list.slice(0, leftLength);
  }, [list, isListDivided]);
  const right = useMemo(() => {
    if (!isListDivided) {
      return [];
    }
    return list.slice(leftLength);
  }, [list, isListDivided]);

  const collapse = useCallback(() => {
    setListDivided(false);
  }, []);

  return {
    left,
    right,
    collapse,
  };
};
