import { useState, useEffect, RefObject } from 'react';

export const useFocus = (ref: RefObject<HTMLElement | null | undefined>) => {
  const [isFocused, setFocused] = useState(false);

  useEffect(() => {
    const node = ref.current;
    if (!node) {
      return;
    }

    const handleFocus = () => {
      setFocused(true);
    };
    const handleBlur = () => {
      setFocused(false);
    };

    node.addEventListener('focus', handleFocus);
    node.addEventListener('blur', handleBlur);
    return () => {
      node.removeEventListener('focus', handleFocus);
      node.removeEventListener('blur', handleBlur);
    };
  }, []);

  return isFocused;
};
