import { useEffect, RefObject } from 'react';

export const useFocusKeeping = (controlRef: RefObject<HTMLElement>) => {
  useEffect(() => {
    const node = controlRef.current;
    node?.focus();

    const handleKeyDown = (event: KeyboardEvent) => {
      if (event.ctrlKey || event.metaKey || document.activeElement === node) {
        return;
      }

      node?.focus();
    };

    const handleCopy = () => {
      setTimeout(() => {
        node?.focus();
      }, 0);
    };

    const handlePaste = () => {
      node?.focus();
    };

    document.addEventListener('keydown', handleKeyDown);
    document.addEventListener('copy', handleCopy);
    document.addEventListener('paste', handlePaste);

    return () => {
      document.removeEventListener('keydown', handleKeyDown);
      document.removeEventListener('copy', handleCopy);
      document.removeEventListener('paste', handlePaste);
    };
  }, []);
};
