import { useEffect, useRef } from 'react';
import { UseInterval } from './useInterval.types';

export const useInterval: UseInterval = (props) => {
  const { callback, timeout, isActive } = props;

  const savedCallback = useRef(callback);

  useEffect(() => {
    savedCallback.current = callback;
  }, [callback]);

  useEffect(() => {
    if (!isActive) {
      return;
    }

    const id = setInterval(() => savedCallback.current(), timeout);

    return () => clearInterval(id);
  }, [isActive, timeout]);
};
