import { useEffect } from 'react';

export const useNonPassiveWheel = (
  node: HTMLElement | null,
  onWheel: (event: WheelEvent) => void,
) => {
  useEffect(() => {
    if (!node) {
      return;
    }

    node.addEventListener('wheel', onWheel, { passive: false });
    return () => {
      node.removeEventListener('wheel', onWheel);
    };
  }, [node, onWheel]);
};
