import { RefObject, useEffect, useCallback } from 'react';

export const useOutsideClick = (
  ref: RefObject<HTMLElement | undefined>,
  onOutsideClick?: () => void,
  capture: boolean = false,
  event: string = 'mousedown',
) => {
  const handleClick = useCallback(
    (event: MouseEvent) => {
      if (!ref.current) {
        return;
      }

      const eventPath = event.composedPath();
      const isElementInPath = eventPath.includes(ref.current);

      if (!isElementInPath && onOutsideClick) {
        onOutsideClick();
      }
    },
    [ref, onOutsideClick],
  );

  useEffect(() => {
    document.addEventListener(event, handleClick, capture);
    return () => {
      document.removeEventListener(event, handleClick, capture);
    };
  }, [capture, handleClick]);
};
