import React, { useEffect, useRef, useState } from 'react';

export function useResizeNotify<T extends HTMLElement>(): [React.RefObject<T>, number | null] {
  const domNode = useRef<T>(null);

  const [width, setWidth] = useState<number | null>(null);

  useEffect(() => {
    const fn = () => {
      if (domNode.current) {
        setWidth(domNode.current.getBoundingClientRect().width);
      }
    };

    fn();
    window.addEventListener('resize', fn);

    return () => {
      window.removeEventListener('resize', fn);
    };
  }, []);

  return [domNode, width];
}
