import { useCallback } from 'react';

export const useVerticalScroll = (node: HTMLElement | null) => {
  return useCallback(
    (event: WheelEvent) => {
      if (!node || event.composedPath().includes(node)) {
        return;
      }

      const top = node.scrollTop + event.deltaY;
      const isOverscrollTop = top <= 0;
      const isOverscrollBottom = node.scrollHeight <= node.clientHeight + top;
      const isScrollingInsideNode = !isOverscrollTop && !isOverscrollBottom;
      if (isScrollingInsideNode) {
        event.preventDefault();
      }

      node.scrollTo({
        top,
        behavior: 'auto',
      });
    },
    [node],
  );
};
